/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.AbsoluteY;
import emulator.hardware.nmos6502.operands.Immediate;
import emulator.hardware.nmos6502.operands.IndirectX;
import emulator.hardware.nmos6502.operands.IndirectY;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class ORA
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte value = cpu.getAccu();
        value.or(operand.getByte());
        cpu.setAccu(value);
        Flags6502 flags = cpu.getFlags();
        flags.setNZFromValue(value);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "ORA";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(9, this, new Immediate());
        cset.defineCommand(5, this, new ZeroPage());
        cset.defineCommand(21, this, new ZeroPageX());
        cset.defineCommand(13, this, new Absolute());
        cset.defineCommand(29, this, new AbsoluteX());
        cset.defineCommand(25, this, new AbsoluteY());
        cset.defineCommand(1, this, new IndirectX());
        cset.defineCommand(17, this, new IndirectY());
    }
}

